import { isPresent } from 'ember-utils';
import { moduleFor, test } from 'ember-qunit';
import wait from 'ember-test-helpers/wait';
import {
  setup as setupMirage, teardown as teardownMirage
} from '../../helpers/setup-mirage-for-integration';

let serializer;

moduleFor('serializer:presence-settings', 'Integration | Serializer | presence-settings', {
  integration: true,

  beforeEach() {
    setupMirage(this);
    serializer = this.subject();
  },

  afterEach() {
    teardownMirage(this);
  }
});

test('normalizeQueryRecordResponse returns JSONAPI format', function (assert) {
  let id = '1234';
  serializer.set('session.userData', {id});
  let share = 'full';
  let shareActivity = true;
  let payload = { share: share, share_activity: shareActivity };
  let results = serializer.normalizeQueryRecordResponse(null, null, payload);
  let { data } = results;

  assert.ok(isPresent(data), 'adds `data` to payload');
  assert.equal(data.id, id, 'session id is used as record id');
  assert.equal(data.type, 'presence-settings', 'correct model name added');

  let attrs = data.attributes;
  assert.ok(isPresent(attrs), 'adds `attributes` to `data`');
  assert.equal(attrs, payload, 'attributes are the settings payload');
  assert.equal(attrs.share, share, 'share setting preserved');
  assert.equal(attrs.share_activity, shareActivity, 'share_activity setting preserved');

  return wait();
});
