import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import Service from 'ember-service';

const CHANNEL_ID = 9000;

moduleForIntegration('service:ads', 'Integration | Service | Ads');

test('#startCommercial', function (assert) {
  assert.expect(4);

  let apiStub = Service.extend({
    authRequest(method, url, data, options) {
      assert.equal(method, 'post', 'API request method is POST');
      assert.equal(url, `channels/${ CHANNEL_ID }/commercial`, 'API url is correct');
      assert.propEqual(options, { version: 5, contentType: 'application/json; charset=UTF-8' }, 'request options is valid');
      assert.equal(typeof data, 'string');
    }
  });

  this.register('service:api', apiStub);

  this.subject().startCommercial(CHANNEL_ID, 30);
});

test('#getAdBreakSettings', function (assert) {
  assert.expect(3);

  let apiStub = Service.extend({
    authRequest(method, url, data, options) {
      assert.equal(method, 'get', 'API request method is GET');
      assert.equal(url, `/kraken/channels/${ CHANNEL_ID }/ads/settings`, 'API url is correct');
      assert.propEqual(options, { version: 5 }, 'request options are valid');
    }
  });

  this.register('service:api', apiStub);

  this.subject().getAdBreakSettings(CHANNEL_ID);
});

