import { test } from 'ember-qunit';
import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';

moduleForIntegration('service:autohost', 'Integration | Service | autohost', {
});

test('get settings', function(assert) {
  assert.expect(2);

  let service = this.subject();
  this.server.create('autohost-settings', {enabled: true, team_host: true});

  return service.updateSettings().then((settings) => {
    assert.equal(settings.enabled, true, 'enabled');
    assert.equal(settings.team_host, true, 'team hosting');
  });
});

test('update settings', function(assert) {
  assert.expect(4);

  let service = this.subject();
  this.server.create('autohost-settings', {enabled: true, team_host: false});

  return service.setSettings('enabled', false).then((settings) => {
    assert.equal(settings.enabled, false, 'disabled');
    assert.equal(settings.team_host, false,'not team hosting');
    return service.setSettings('team_host', true);
  }).then((settings) => {
    assert.equal(settings.enabled, false, 'disabled');
    assert.equal(settings.team_host, true, 'team hosting');
  });
});

test('get list', function(assert) {
  assert.expect(5);

  let service = this.subject();

  this.server.create('channel', { name: 'autohost_target' });

  return service.updateList().then((targetChannels) => {
    assert.equal(targetChannels.length, 1, 'target');
    assert.equal(targetChannels[0].name, 'autohost_target', 'correct target');
  }).then(() => {
    assert.equal(service.get('list').length, 1, 'target');
    assert.equal(service.get('list')[0].name, 'autohost_target', 'correct target');
    assert.equal(service.get('listMap')['autohost_target'], true, 'target in map');
  });
});

test('set list', function(assert) {
  assert.expect(1);

  let service = this.subject();

  this.server.create('channel', { name: 'autohost_target' });
  this.server.create('channel', { name: 'autohost_target' });

  let ids = [0];
  return service.setList(ids).then((targetChannels) => {
    assert.equal(targetChannels.length, 1, 'target');
  });
});

test('set empty list', function(assert) {
  assert.expect(1);

  let service = this.subject();

  this.server.create('channel', { name: 'autohost_target' });
  this.server.create('channel', { name: 'autohost_target' });

  let ids = [];
  return service.setList(ids).then((targetChannels) => {
    assert.equal(targetChannels.length, 0, 'no targets');
  });
});

test('add channel', function(assert) {
  assert.expect(2);

  let service = this.subject();

  this.server.create('channel', { _id: 1, name: 'autohost_target' });
  this.server.create('channel', { _id: 2 });

  return service.addChannelToList(2).then((targetChannels) => {
    assert.equal(targetChannels.length, 2, 'both targets');
    assert.equal(targetChannels[1]._id, 2, 'added channel on bottom');
  });
});
