import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import Service from 'ember-service';

const CHANNEL_ID = 9000;

moduleForIntegration('service:ingest', 'Integration | Service | Ingest');

test('#getBitrate', function (assert) {
  assert.expect(2);

  let apiStub = Service.extend({
    authRequest(method, url) {
      assert.equal(method, 'get', 'API request method is GET');
      assert.equal(url, `/kraken/ingest/bitrate`, 'API url is correct');
    }
  });

  this.register('service:api', apiStub);

  this.subject().getBitrate();
});

test('#getHealth', function (assert) {
  assert.expect(3);

  let apiStub = Service.extend({
    authRequest(method, url, data, options) {
      assert.equal(method, 'get', 'API request method is GET');
      assert.equal(url, `/kraken/channels/${CHANNEL_ID}/ingest/health`, 'API url is correct');
      assert.propEqual(options, { version: 5 }, 'request options is valid');
    }
  });

  this.register('service:api', apiStub);

  this.subject().getHealth({ channelID: CHANNEL_ID });
});
