import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import gamesNewReleasesScenario from 'web-client/mirage/scenarios/games-new-releases';

const USER_LANGUAGES = [ 'en' ];

moduleForIntegration('service:new-releases', 'Integration | Service | service:new-releases');

test('no game new releases available', function(assert) {
  assert.expect(1);

  let service = this.subject();

  gamesNewReleasesScenario(this.server, { releasesCount: 0 });

  return service.getGamesNewReleases(USER_LANGUAGES).then((gamesNewReleases) => {
    assert.equal(gamesNewReleases.length, 0, 'has no game new releases');
  });
});

test('game new releases available', function(assert) {
  assert.expect(3);

  let service = this.subject();

  gamesNewReleasesScenario(this.server, { releasesCount: 2, videosCount: 4, game: 'testGame' });

  return service.getGamesNewReleases(USER_LANGUAGES).then((gamesNewReleases) => {
    assert.equal(gamesNewReleases.length, 2, 'has game new releases');
    assert.equal(gamesNewReleases[0].get('game'), 'testGame', 'has correct game');
    assert.equal(gamesNewReleases[0].get('videos').length, 4, 'has correct number of videos');
  });
});

test('game new releases works with multiple languages set', function(assert) {
  assert.expect(3);

  let service = this.subject();
  let userLanguages = ['en', 'ru'];

  gamesNewReleasesScenario(this.server, { releasesCount: 2, videosCount: 4 });

  return service.getGamesNewReleases(userLanguages).then((gamesNewReleases) => {
    assert.equal(gamesNewReleases.length, 2, 'has game new releases');
    assert.equal(gamesNewReleases[0].get('game'), 'League of Legends', 'has correct game');
    assert.equal(gamesNewReleases[0].get('videos').length, 4, 'has correct number of videos');
  });
});
