import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import recentlyWatchedStreamsScenario from 'web-client/mirage/scenarios/recently-watched-streams';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import { assign } from 'ember-platform';

const TOKEN = 'foobar';
const OauthSession = AuthenticatedSession.extend({
  userData: assign({chat_oauth_token: TOKEN}, AuthenticatedSession.prototype.userData)
});

moduleForIntegration('service:recently-watched-streams', 'Integration | Service | services/recently-watched-streams', {
  beforeEach() {
    this.register('service:session', OauthSession);
  }
});

test('logged in with recently watched streams api request error', function(assert) {
  assert.expect(1);

  let service = this.subject();

  recentlyWatchedStreamsScenario(this.server, {recentlyWatchedStreamsResponseCode: 401});

  return service.getRecentlyWatchedStreams().then((streams) => {
    assert.equal(streams.length, 0, 'no recently watched streams');
  });
});

test('logged in with available recently watched streams', function(assert) {
  assert.expect(1);

  let service = this.subject();

  recentlyWatchedStreamsScenario(this.server, {streamsCount: 4});

  return service.getRecentlyWatchedStreams(TOKEN).then((streams) => {
    assert.equal(streams.length, 4, 'stores recently watched streams');
  });
});
