import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import recommendedStreamsScenario from 'web-client/mirage/scenarios/recommended-streams';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import { assign } from 'ember-platform';

const TOKEN = 'foobar';
const OauthSession = AuthenticatedSession.extend({
  userData: assign({chat_oauth_token: TOKEN}, AuthenticatedSession.prototype.userData)
});

moduleForIntegration('service:similar-channels', 'Integration | Service | Similar Channels', {
  beforeEach() {
    this.register('service:session', OauthSession);
  }
});

test('logged in with available api request error', function(assert) {
  assert.expect(1);

  let service = this.subject();

  recommendedStreamsScenario(this.server, {available: false, availableResponseCode: 401});

  return service.findRecommendations().then(() => {
    assert.equal(service.get('recommendationsAvailable'), false, 'does not enable recommendations');
  });
});

test('logged in with recommended api request error', function(assert) {
  assert.expect(2);

  let service = this.subject();

  recommendedStreamsScenario(this.server, {available: true, recommendedResponseCode: 401});

  return service.findRecommendations().then(() => {
    assert.equal(service.get('recommendationsAvailable'), true, 'enables recommendations');
    assert.equal(service.get('recommendations').length, 0, 'no recommendations');
  });
});

test('logged in with unavailable recommendations', function(assert) {
  assert.expect(1);

  let service = this.subject();

  recommendedStreamsScenario(this.server, {available: false});

  return service._findAvailable(TOKEN).then(() => {
    assert.equal(service.get('recommendationsAvailable'), false, 'does not enable recommendations');
  });
});

test('logged in with available recommendations', function(assert) {
  assert.expect(1);

  let service = this.subject();

  recommendedStreamsScenario(this.server, {available: true});

  return service._findAvailable(TOKEN).then(() => {
    assert.equal(service.get('recommendationsAvailable'), true, 'enables recommendations');
  });
});

test('logged in with available recommendations', function(assert) {
  assert.expect(1);

  let service = this.subject();

  recommendedStreamsScenario(this.server, {available: false, channelsCount: 1, streamsCount: 1});

  return service._findRecommendations(TOKEN).then(() => {
    assert.equal(service.get('recommendations').length, 1, 'stores recommendations');
  });
});

test('similar channels', function(assert) {
  assert.expect(1);

  let service = this.subject();

  this.server.create('channel', { name: 'similar' });

  return service.getSimilarChannels().then(() => {
    assert.equal(service.get('similarChannels').length, 1, 'stores similar channels');
  });
});
