import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import Service from 'ember-service';

import { VERSION } from 'web-client/services/subscriptions';

const CHANNEL_ID = 9000;
const BADGE_ID = 12345;

let ApiStub, service;

moduleForIntegration('service:subscriptions', 'Integration | Service | Subscriptions');

test('#getBadges', function (assert) {
  assert.expect(2);

  ApiStub = Service.extend({
    request(method, url) {
      assert.equal(method, 'get', 'API request method is GET');
      assert.equal(url, `/subscriptions/v${VERSION}/channels/${CHANNEL_ID}/badges`, 'API url is correct');
    }
  });

  this.register('service:api', ApiStub);

  service = this.subject();

  service.getBadges({ channelID: CHANNEL_ID });
});

test('#createBadge', function (assert) {
  assert.expect(4);

  ApiStub = Service.extend({
    request(method, url, data, options) {
      assert.equal(method, 'post', 'API request method is POST');
      assert.equal(url, `/subscriptions/v${VERSION}/channels/${CHANNEL_ID}/badges`, 'API url is correct');
      assert.ok(data instanceof FormData, 'request data is form data');
      assert.propEqual(options, { contentType: false, processData: false }, 'request options is valid');
    }
  });

  this.register('service:api', ApiStub);

  service = this.subject();

  service.createBadge({
    channelID: CHANNEL_ID,
    formData: new FormData()
  });
});

test('#deleteBadge', function (assert) {
  assert.expect(2);

  ApiStub = Service.extend({
    request(method, url) {
      assert.equal(method, 'delete', 'API request method is DELETE');
      assert.equal(url, `/subscriptions/v${VERSION}/channels/${CHANNEL_ID}/badges/${BADGE_ID}`, 'API url is correct');
    }
  });

  this.register('service:api', ApiStub);

  service = this.subject();

  service.deleteBadge({
    channelID: CHANNEL_ID,
    badgeID: BADGE_ID
  });
});

test('#getTimeoutStatuses', function (assert) {
  assert.expect(2);

  ApiStub = Service.extend({
    request(method, url) {
      assert.equal(method, 'get', 'API request method is GET');
      assert.equal(
        url,
        `/subscriptions/v${VERSION}/channels/${CHANNEL_ID}/timeout_statuses`,
        'API url is correct'
      );
    }
  });

  this.register('service:api', ApiStub);

  service = this.subject();

  service.getTimeoutStatuses({ channelID: CHANNEL_ID });
});

test('#getSubscriberCount', function (assert) {
  assert.expect(2);

  let channelLogin = 'twitch';

  ApiStub = Service.extend({
    request(method, url) {
      assert.equal(method, 'get', 'API request method is GET');
      assert.equal(
        url,
        `/api/channels/${channelLogin}/subscriber_count`,
        'API url is correct'
      );
    }
  });

  this.register('service:api', ApiStub);

  service = this.subject();

  service.getSubscriberCount({ channelLogin: channelLogin });
});
