import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import trendingVideosScenario from 'web-client/mirage/scenarios/trending-videos';

const USER_LANGUAGES = [ 'en' ];

moduleForIntegration('service:trending-videos', 'Integration | Service | service:trending-videos');

test('no trending videos available', function(assert) {
  assert.expect(1);

  let service = this.subject();

  trendingVideosScenario(this.server, { videosCount: 0 });

  return service.getTrendingVideos(USER_LANGUAGES).then((trendingVideos) => {
    assert.equal(trendingVideos.length, 0, 'has no trending videos');
  });
});

test('trending videos available', function(assert) {
  assert.expect(1);

  let service = this.subject();

  trendingVideosScenario(this.server, { videosCount: 2 });

  return service.getTrendingVideos(USER_LANGUAGES).then((trendingVideos) => {
    assert.equal(trendingVideos.length, 2, 'has trending videos');
  });
});

test('works with multiple languages set', function(assert) {
  assert.expect(1);

  let service = this.subject();
  let userLanguages = ['en', 'ru'];

  trendingVideosScenario(this.server, { videosCount: 2 });

  return service.getTrendingVideos(userLanguages).then((trendingVideos) => {
    assert.equal(trendingVideos.length, 2, 'has trending videos');
  });
});
