import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import {
  WEB_CLIENT_CLIENT_ID,
  CLIENT_ID_HEADER
} from 'web-client/services/twitch-friends-list/backend/ajax';

moduleForIntegration(
  'service:twitch-friends-list/backend/ajax',
  'Integration | Service | Twitch Friends List - Backend - Ajax');

test('#request includes client_id', function(assert) {
  assert.expect(1);

  let clientIdHeader;
  let url = '/foo';
  let service = this.subject();

  this.server.get(url, (schema, request) => {
    clientIdHeader = request.requestHeaders[CLIENT_ID_HEADER];
  });

  return service.request(url).finally(() => {
    assert.equal(clientIdHeader, WEB_CLIENT_CLIENT_ID, 'Client-ID header is passed');
  });
});
