import PubsubDriver from 'pubsub-js-client/PubsubDriver';
import moduleForIntegration from '../../../../helpers/module-for-integration';
import test from 'ember-sinon-qunit/test-support/test';
import wait from 'ember-test-helpers/wait';
import ENV from 'web-client/config/environment';
import { configurePubSub as presencePubSub } from 'web-client/utilities/presence-util';

moduleForIntegration('service:twitch-presence/presence', 'Integration | Service | presence', {
  beforeEach() {
    let driver = PubsubDriver.getInstance(ENV.pubsub.environment);
    presencePubSub(driver);
    this.inject.service('session');
    this.session.isAuthenticated = true;
    this.session.userData = { id: 42 };
  }
});

test('initPolling', function (assert) {
  let service = this.subject({
    initSettings() {}
  });
  let polling = service.get('polling');
  let stub = this.stub(polling, 'startPolling');

  service.initPolling();

  assert.ok(stub.calledOnce, 'startPolling was called');

  return wait();
});

test('setOnline - not online', function (assert) {
  let service = this.subject({
    initSettings() {},
    settings: { share: 'none' }
  });
  let stub = this.stub(service, 'setVisibility');

  service.setVisibility(true);

  assert.ok(stub.calledOnce, 'setVisibility was called');
  let { args } = stub.firstCall;
  assert.equal(args.length, 1, '1 arg passed to setVisibility');
  assert.equal(args[0], true, 'updates status to online');

  return wait();
});

test('setInvisible - online', function (assert) {
  let service = this.subject({
    initSettings() {},
    settings: { share: 'full' }
  });
  let stub = this.stub(service, 'setVisibility');

  service.setVisibility(false);

  assert.ok(stub.calledOnce, 'setVisibility was called');
  let { args } = stub.firstCall;
  assert.equal(args.length, 1, '1 arg passed to setVisibility');
  assert.equal(args[0], false, 'updates status to invisible');

  return wait();
});
