import moduleForIntegration from 'web-client/tests/helpers/module-for-integration';
import { test } from 'ember-qunit';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import RSVP from 'rsvp';

const PLATFORM_ID = 'hirez';
const CHANNEL_ID = 'hireztv';

const LinkedVhsUser = AuthenticatedSession.extend({
  getOAuthToken() {
    return RSVP.resolve('connected');
  }
});

const UnlinkedVhsUser = AuthenticatedSession.extend({
  getOAuthToken() {
    return RSVP.resolve('notconnected');
  }
});

moduleForIntegration('service:vhs', 'Integration | Service | Viewer Heartbeat');

test('#getPlatformForChannel', function (assert) {
  assert.expect(1);

  let service = this.subject();
  return assert.ok(service.getPlatformForChannel(CHANNEL_ID));
});

test('#getPlatformById', function (assert) {
  assert.expect(1);

  let service = this.subject();
  return assert.ok(service.getPlatformById(PLATFORM_ID));
});

test('#getConnectionLinked', function (assert) {
  assert.expect(1);

  this.register('service:session', LinkedVhsUser);

  let service = this.subject();
  return service.isCurrentUserLinkedToPlatform(PLATFORM_ID).then(isLinked => {
    assert.ok(isLinked);
  });
});

test('#getConnectionUnlinked', function (assert) {
  assert.expect(1);

  this.register('service:session', UnlinkedVhsUser);

  let service = this.subject();
  return service.isCurrentUserLinkedToPlatform(PLATFORM_ID).then(isLinked => {
    assert.notOk(isLinked);
  });
});
