import focus from 'web-client/tests/helpers/focus';

export default class Autohost {
  constructor(context) {
    this.context = context;
  }

  targets() {
    return this.context.$('[data-test-selector=list-item]');
  }

  onboardingRecommendedChannels() {
    return this.context.$('[data-test-selector=autohost-onboarding-recommended-channel]');
  }

  onboardingRecommendedAddButtons() {
    return this.context.$('[data-test-selector=autohost-onboarding-recommended-channel]').find('[data-test-selector=add-channel-button]');
  }

  dismissOnboardingButton() {
    return this.context.$('[data-test-selector=dismiss-onboarding]');
  }

  enabledSwitch() {
    return this.context.$('[data-test-selector=enabled-switch]');
  }

  enabledSwitchIsActive() {
    return this.enabledSwitch().hasClass('active');
  }

  teamSwitch() {
    return this.context.$('[data-test-selector=team-host-switch]');
  }

  teamSwitchIsActive() {
    return this.teamSwitch().hasClass('active');
  }

  recommendedSwitch() {
    return this.context.$('[data-test-selector=recommended-host-switch]');
  }

  recommendedSwitchIsActive() {
    return this.recommendedSwitch().hasClass('active');
  }

  addChannelsButton() {
    return this.context.$('[data-test-selector=add-channels]');
  }

  viewRecommended() {
    return this.context.$('[data-test-selector=view-recommended]');
  }

  randomStrategyButton() {
    return this.context.$('[data-test-selector=random-host]');
  }

  orderedStrategyButton() {
    return this.context.$('[data-test-selector=ordered-host]');
  }

  deleteTargetButton() {
    return this.context.$('[data-test-selector=delete-channel]');
  }

  moveUpButton() {
    return this.context.$('[data-test-selector=move-up-channel]');
  }

  moveDownButton() {
    return this.context.$('[data-test-selector=move-down-channel]');
  }

  similarChannelsView() {
    return this.context.$('[data-test-selector=view-similar-channels]');
  }

  openSearchButton() {
    return this.context.$('[data-test-selector=open-search]');
  }

  closeSearchButton() {
    return this.context.$('[data-test-selector=close-search]');
  }

  searchInput() {
    return this.context.$('[data-test-selector=navigation-search-field]');
  }

  searchResultPanel() {
    return this.context.$('.search-result-view');
  }

  enterTerm(term) {
    focus(this.searchInput());
    this.context.$('input').val(term).trigger('input');
  }

  searchHits() {
    return this.searchResultPanel().find('[data-test-selector=users-hits] h5').toArray().map((el) => {
      return $(el).text().trim();
    });
  }

  searchResults() {
    return this.searchResultPanel().find('[data-test-selector=result-button]');
  }

  searchResultsAddButtons() {
    return this.searchResultPanel().find('[data-test-selector=add-channel-button]');
  }

  searchResultsRemoveButtons() {
    return this.searchResultPanel().find('[data-test-selector=remove-channel-button]');
  }

  recommendedResultsHeader() {
    return this.context.$('[data-test-selector=recommended-header]');
  }

  recommendedResults() {
    return this.context.$('[data-test-selector=autohost-recommended-channel]');
  }

  searchRecommendedResultsAddButtons() {
    return this.searchResultPanel().find('[data-test-selector=add-channel-button]');
  }

  searchRecommendedResultsRemoveButtons() {
    return this.searchResultPanel().find('[data-test-selector=remove-channel-button]');
  }

  recommendedResultsAddButtons() {
    return this.context.$('[data-test-selector=add-channel-button]');
  }

  recommendedResultsRemoveButtons() {
    return this.context.$('[data-test-selector=remove-channel-button]');
  }
}
