import EmberObject from 'ember-object';
import $ from 'jquery';

export default EmberObject.extend({
  _url: '/',

  keyCodes: {
    enter: 13
  },

  url() {
    return this.get('_url');
  },

  /*
  * TODO: This function usually does <h2> lookups, so this function should be
  * renamed to header, so that it isn't confused with the title tag in head
  */
  title(text) {
    return `.title:contains(${text})`;
  },

  /*
  * The testing container does not include its own <head> tag,
  * so find('head') here does not behave like we'd expect,
  * so we use jQuery to select the head tag instead
  */
  canonicalUrl() {
    return $('head link[rel="canonical"]').attr('href');
  },

  headTitle() {
    return $('head title').text().trim();
  },

  // return false instead of [], which is truthy
  // when not found, so that assertions can use this.
  // Example Usage: assert.ok(page.isFound('.channel'))
  isFound(selector, context) {
    let results = find(selector, context);
    return results.length > 0 ? results : false;
  },

  isNotFound(selector, context) {
    let results = find(selector, context);
    return results.length === 0;
  },

  scrollContainer() {
    return find('.js-directory.tse-content').parent();
  },

  scroll(offsetFromTop) {
    let $el = this.scrollContainer();
    scrollTop($el, offsetFromTop);
    triggerEvent($el, 'scroll');
  },

  scrollDown() {
    this.scroll(10000);
  },

  scrollUp() {
    this.scroll(0);
  },

  persistentPlayer() {
    return find('.js-player-persistent');
  },

  noChannelMessage() {
    return find('.js-test-no-channel');
  }
});
