import Base from './base';

export default Base.extend({
  _url: '/directory/all',

  recommendedChannelLink() {
    return '.js-recommended-channel a:eq(0)';
  },

  recommendedChannelHref() {
    return find(this.recommendedChannelLink()).attr('href');
  },

  languageFilter() {
    return '.js-language-control';
  },

  topChannelsTitle(text = 'Top Channels') {
    return this.title(text);
  },

  videoThumbs() {
    return '.stream.item';
  },

  navigationTabs() {
    return '.js-nav a';
  },

  xboxOneTab() {
    return '.js-nav a:contains("Xbox One")';
  },

  psFourTab() {
    return '.js-nav a:contains("PlayStation 4")';
  },

  hasHeaderText(text) {
    return this.isFound(`.section_header.first h3:contains(${text})`);
  },

  thumbLink(channelName){
    return `.stream.item a[href="/${channelName}"]`;
  },

  hasRightSidebarText(text) {
    return this.isFound(`#right_col *:contains(${text})`);
  },

  hasLeftSidebarText(text) {
    return this.isFound(`#left_col *:contains(${text})`);
  }
});
