import Ember from 'ember';
import Base from './base';

const { computed } = Ember;

export default Base.extend({
  name: 'twitch',

  _url: computed('name', function() {
    return `/${this.get('name')}`;
  }),

  feedTextarea: '.activity-create textarea',

  postFeedButton: '.activity-create__actions button',

  postModControls: '.js-activity-menu button',

  deletePostMenu: `.js-activity-menu .balloon__list a:contains('Delete')`,

  sharePostMenu: `.js-activity-menu .balloon__list a:contains('Share')`,

  reportPostMenu: `.js-activity-menu .activity-notice__content a:contains("Report")`,

  confirmDeletePost: '.js-activity-menu .activity-notice__content.show a.alert:contains("Delete")',

  confirmSharePost: '.js-activity-menu .activity-notice__content a.alert:contains("Share")',

  confirmReportPost: '.js-activity-menu .activity-notice__content a.mg-r-1:contains("Report")',

  sharePostUrl: '.js-activity-menu .js-share-url',

  commentTextarea: '.js-activity-add-comment textarea',

  commentModControls: '.activity-card__comments .js-activity-menu button',

  deleteCommentMenu: `.activity-card__comments .js-activity-menu .balloon__list a.js-delete`,

  confirmDeleteComment: '.activity-card__comments .js-activity-menu .activity-notice__content.show a.js-delete-confirm',

  commentReaction: '.activity-comment__reaction',

  reactButton: '.activity-react button',

  hasFeed(text = 'Hello World!') {
    return this.isFound(`.activity-card:contains(${text})`);
  },

  hasComment(text = 'Best comment ever') {
    return this.isFound(`.activity-body:contains(${text})`);
  }
});
