import computed from 'ember-computed';
import Base from './base';

export default Base.extend({
  name: 'twitch',

  _url: computed('name', function () {
    return `/${ this.get('name') }`;
  }),

  nonSelectedTabbedView: '.tabs li:not(.selected):first a',

  channelLink() {
    return '.channel-name';
  },

  visibleEditPanel() {
    return '.edit-panels-toggle:visible';
  },

  chatInput: 'textarea.chat_text_input',

  hasFromName(name = 'Friend') {
    return this.isFound(`.message-line .from:contains(${name})`);
  },

  hasMessage(text = 'hello') {
    return this.isFound(`.message-line.chat-line:contains(${text})`);
  },

  fillInChat(message) {
    fillIn(this.chatInput, message);
    keyEvent(this.chatInput, 'keydown', this.keyCodes.enter);
  },

  // Resub notification:
  resubParentDivClass: '.top-notification--resub',

  resubStickyMessage: '.top-notification--resub .sticky-message',
  resubStickyMessageHiddenClass: 'sticky-message--hidden',

  resubMessage: '.top-notification--resub .resub-message .resub-amt',
  resubFirstShareButton: '.top-notification--resub .resub-message button.button:first',
  resubFirstCloseButton: '.top-notification--resub .resub-message button.button:last',

  resubWrap: '.top-notification--resub .resub-wrap',
  resubWrapHiddenClass: 'resub-wrap--hidden',

  resubNotif: '.top-notification--resub .resub-notif',
  resubNotifShownClass: 'resub-notif--shown',
  resubNotifHiddenClass: 'resub-notif--hidden',
  resubNotifParagraph: '.top-notification--resub .resub-notif__notice p',
  resubNotifInput: `.top-notification--resub .resub-notif .resub-notif__message input.text.resub-input[type="text"]`,
  resubSecondShareButton: '.top-notification--resub .resub-notif .resub-notif__message button.button',
  resubSecondCloseButton: '.top-notification--resub .resub-notif .resub-notif__close button.button',
  hostModeMessage: '.js-host-frame .js-hosting-card-title',


  hasResubUserNoticeSystemMessage(text) {
    return this.isFound(`.message-line.chat-line.special-message .system-msg:contains(${ text })`);
  },

  hasResubUserNoticeCustomMessage(text) {
    return this.isFound(`.message-line.chat-line.special-message .message:contains(${ text })`);
  },

  showsStat(parentClass, count) {
    return this.isFound(`.${parentClass} .cn-tabs__count:contains(${count})`);
  }
});
