import Base from '../base';
import computed from 'ember-computed';

export default Base.extend({
  name: 'twitch',
  _url: computed('name', function () {
    return `/${this.get('name')}`;
  }),

  chatContainer: '.js-rightcol-content .js-chat-container',
  chatInput: 'textarea.chat_text_input',
  profileButton: '.cn-bar .cn-tabs__profile',
  videosButton: '.cn-bar .js-cn-tabs__videos',
  followersButton: '.cn-bar .js-cn-tabs__followers',
  followingButton: '.cn-bar .js-cn-tabs__following',
  clipsTabButton: '.cn-bar .js-cn-tab-clips',
  placeholder: '.player-placeholder',

  enterChatText(message) {
    fillIn(this.chatInput, message);
  },

  profileCardLink(name) {
    return this.isFound(`.profile-card a:contains(${name})`);
  },

  metadataBox() {
    return this.isFound('.qa-metadata-box');
  },

  video(title) {
    if(title) {
      return `.video.item .card__title a[title="${title}"]`;
    }

    return '.video.item';
  },

  videoFilter(option) {
    if (option) {
      return `.js-vod-filter li a:contains(${option})`;
    }

    return '.js-vod-filter';
  },

  uploadCarouselVideo() {
    return '.card-carousel__item .video.item';
  }
});
