import computed from 'ember-computed';
import Base from 'web-client/tests/pages/base';

const SubscriptionDashPage = Base.extend({
  subroute: '',

  _url: computed('username', 'subroute', function () {
    let username = this.get('username');
    let subroute = this.get('subroute');

    return `/${username}/dashboard/subscription/${subroute}`;
  }),

  newDashboardParagraphEmptyGrid() {
    return '.new-dashboard p.empty-grid';
  },

  subscriptionDash() {
    return '.subscription-dash';
  },

  pageTitle() {
    return '.subscription-dash .header-content .title';
  },

  backToIndex() {
    return '.subscription-dash .header-back';
  }
});

export default SubscriptionDashPage;

export const AdsPage = SubscriptionDashPage.extend({
  subroute: 'ads',

  checkbox() {
    return '.subscription-dash input[type="checkbox"]';
  },

  warningModal() {
    return '.twitch_subwindow_container .item';
  },

  warningModalCloseButton() {
    return '.twitch_subwindow_container button.js-subwindow-close';
  },

  warningModalConfirmButton() {
    return '.twitch_subwindow_container .button.js-subwindow-submit';
  }
});

export const BadgesPage = SubscriptionDashPage.extend({
  subroute: 'badges',

  subBadgeImagePicker() {
    return '.js-sub-badge-image-picker';
  },

  subBadgeImagePickerImage() {
    return `${this.subBadgeImagePicker()} img`;
  },

  subBadgeImagePickerInput() {
    return `${this.subBadgeImagePicker()} input[type="file"]`;
  },

  subBadgeImagePickerInputByIndex(index) {
    return `${this.subBadgeImagePickerInput()}:eq(${index})`;
  },

  subBadgeImagePickerTooltip() {
    return `${this.subBadgeImagePicker()} div.balloon.balloon--tooltip.balloon--down.balloon--center`;
  },

  subBadgeImagePickerAlert() {
    return `${this.subBadgeImagePicker()} div.balloon.balloon--alert.balloon--up.balloon--center.balloon--fancy`;
  },

  subBadgeDisplay() {
    return '.js-sub-badge-display';
  },

  subBadgeDisplayFigure() {
    return `${this.subBadgeDisplay()} figure`;
  },

  subBadgeDisplayTooltip() {
    return `${this.subBadgeDisplay()} div.balloon.balloon--tooltip`;
  },

  subBadgeDisplayImage() {
    return `${this.subBadgeDisplay()} img`;
  },

  subBadgeDisplayFigcaption() {
    return `${this.subBadgeDisplay()} figcaption`;
  },

  subBadgeTab() {
    return '.js-sub-badge-tab';
  },

  form() {
    return 'form.cl-input-container';
  },

  formSubmitButton() {
    return `${this.form()} button.button[type="submit"]`;
  },

  modal() {
    return '.twitch_subwindow_container .twitch_subwindow';
  },

  modalCancelButton() {
    return '.twitch_subwindow_container .buttons button.button.button--text';
  },

  modalConfirmButton() {
    return '.twitch_subwindow_container .buttons button.button:last';
  }
});

export const ChatBadgePage = SubscriptionDashPage.extend({
  subroute: 'chatbadge'
});

export const ChatLimitPage = SubscriptionDashPage.extend({
  subroute: 'chat'
});

export const ChatPerksPage = SubscriptionDashPage.extend({
  subroute: 'chatperks',

  prefixInput() {
    return '.js-prefix';
  },

  prefixPreview() {
    return '.js-prefix-example span';
  }
});

export const CreativePropertiesPage = SubscriptionDashPage.extend({
  subroute: 'creative'
});

export const PaymentsPage = SubscriptionDashPage.extend({
  subroute: 'payments',

  netPaymentFormCheckbox() {
    return '.net-payment-form input[type="checkbox"]';
  },

  scrollContainer() {
    return '.contract-amendments-window';
  },

  contractAmendmentsMessaging() {
    return '.contract-amendments-messaging';
  },

  confirmButton() {
    return '.button.js-subwindow-submit';
  }
});

export const CheerOnboardingPage = SubscriptionDashPage.extend({
  subroute: 'cheer',

  bitsFormCheckbox() {
    return 'input[type="checkbox"].js-bits-enable';
  },

  scrollContainer() {
    return '.contract-amendments-window';
  },

  contractAmendmentsMessaging() {
    return '.contract-amendments-messaging';
  },

  confirmButton() {
    return '.button.js-subwindow-submit';
  }
});

export const StreamlineBountyPage = SubscriptionDashPage.extend({
  subroute: 'streamline',

  streamlineFormCheckbox() {
    return '.streamline-form input[type="checkbox"]';
  },

  scrollContainer() {
    return '.contract-amendments-window';
  },

  contractAmendmentsMessaging() {
    return '.contract-amendments-messaging';
  },

  confirmButton() {
    return '.button.js-subwindow-submit';
  }
});

export const GameCommerceSettingsPage = SubscriptionDashPage.extend({
  subroute: 'game-commerce',

  gameCommerceFormCheckbox() {
    return '.game-commerce-form input[type="checkbox"]';
  },

  scrollContainer() {
    return '.contract-amendments-window';
  },

  contractAmendmentsMessaging() {
    return '.contract-amendments-messaging';
  },

  confirmButton() {
    return '.button.js-subwindow-submit';
  }
});

export const TeespringPage = SubscriptionDashPage.extend({
  subroute: 'teespring'
});

export const TicketInformationPage = SubscriptionDashPage.extend({
  subroute: 'ticket'
});

export const VideoLimitPage = SubscriptionDashPage.extend({
  subroute: 'video'
});
