import Base from '../base';

export default Base.extend({
  _url: '/directory/all',
  liveUrl: '/directory/following/live',
  psFourURL: '/directory/all/ps4',
  xbOneURL: '/directory/all/xb1',

  youFollowTitle(text = 'You Follow') {
    return this.isFound(this.title(text));
  },

  noFollows() {
    return this.isFound('.no-follows:contains(Nobody)');
  },

  channels() {
    return this.isFound('.following-list .channel');
  },

  searchButton() {
    return '.search-button';
  },

  input() {
    return 'input.js-search-input';
  },

  followedChannelLink(type, name = 'CounterPit') {
    let nameFilter = name ? `:contains(${name})` : '.profile-photo';
    return this.isFound(`.following-list.${type} .channel a${nameFilter}`);
  },

  followImageLink(type, href, logo) {
    return this.isFound(`.following-list.${type} .channel a[href="${href}"] img[src="${logo}"]`);
  },

  allVideosUrl(name = 'CounterPit') {
    return `/${name}/videos/all`;
  },

  offlineUrl(name = 'CounterPit') {
    return `/${name}/videos`;
  },

  onlineUrl(name = 'CounterPit') {
    return `/${name}`;
  },

  fullOnlineUrl() {
    return `https://www.twitch.tv${this.onlineUrl()}`;
  },

  liveThumbLink(channelName) {
    return this.isFound(`.stream.item a[href="/${channelName}"][data-tt_content="live_channel"]`);
  },

  liveFollowProfileLink(channelName) {
    return this.isFound(`.stream.item a[href="/${channelName}/profile"][data-tt_content="live_channel"]:contains("${channelName}")`);
  },

  loadMore: 'a.load-more',
  streamItem: '.stream.item'
});
