import Base from '../base';

export const followingLoggedOutMessage = "You must be logged in to see channels you follow";

export default Base.extend({
  _url: '/directory/following',

  hasFollowChannelFTUX() {
    return this.isFound(`*:contains(Never miss the Channels you love.)`);
  },

  hasFollowGameFTUX() {
    return this.isFound(`*:contains(You can now follow your favorite games)`);
  },

  closeButtonSelector: 'button:contains(Close)',
  gameBoxSelector: '.game-item',

  gameTabSelector: '.js-directory a:contains(Games)',

  hasGameIconFor(name) {
    return this.isFound(`.game-item:contains(${name})`);
  },

  hasFollowGamePopup() {
    return this.isFound("*:contains(Choose some games that you'd like to follow.)");
  },

  latestUploadsVideoAtIndex(index) {
    return `[data-test-latest-uploads-video-list] .video:eq(${index}) a`;
  }
});
