import Base from '../base';

export const GAME_NAME = 'AC/DC Rock';

export default Base.extend({
  init() {
    this._super(...arguments);

    this.name = this.name || GAME_NAME;
  },

  url() {
    let name = this.get('name');

    return `/directory/game/${encodeURIComponent(name)}`;
  },

  languageFilter() {
    return '.js-language-control';
  },

  title(name = this.get('name')) {
    return `.title:contains(${name})`;
  },

  followButtonSelector: 'button:contains(Follow)',
  unfollowButtonSelector: 'button.follow.following',

  sidebarFollowingLinkSelector: 'nav a:contains(Following)',

  isFollowing() {
    return this.isFound('button.follow.following');
  },

  isNotFollowing() {
    return !this.isFollowing();
  }
});
