import Base from '../base';

export default Base.extend({
  _url: '/directory',

  title() {
    return '.title:contains(All Games)';
  },

  gameThumbs() {
    return '.game.item';
  },

  thumbLink(gameName){
    return `a[href="/directory/game/${gameName}"]`;
  },

  promotedGame(title) {
    return `.game.item a.game-item.promoted-game[title=${title}]`;
  },

  promotedClickUrl(url) {
    return `.game.item a.game-item.promoted-game[href=${url}]`;
  },

  promotedTrackingPixel(url) {
    return `.game.item img.tracking_pixel[src=${url}]`;
  }
});
