import Base from '../base';

export default Base.extend({
  _url: '/directory/following/hosts',

  liveHostsTitle(text = 'Live Hosts') {
    return this.isFound(this.title(text));
  },

  noFollows() {
    return this.isFound('.following-none');
  },

  noHosts() {
    return this.isFound('.empty-grid');
  },

  hostedChannelLink() {
    return this.isFound('.js-streams .js-channel-link');
  },

  channelUrl(name = 'counterpit') {
    return `/${name}`;
  },

  allVideosUrl(name = 'counterpit') {
    return `https://www.twitch.tv/${name}/videos/all`;
  },

  fullChannelUrl() {
    return `https://www.twitch.tv${this.channelUrl()}`;
  }
});
