import Base from './base';

export default Base.extend({
  _url: '/',

  hasTopGames() {
    return this.isFound('.game.item .game-item:not(.promoted-game)');
  },

  hasFeaturedGames() {
    return this.isFound('.game.item .game-item.promoted-game');
  },

  hasFacebookButton() {
    return this.isFound('#social-media .facebook.button');
  },

  hasTwitterButton() {
    return this.isFound('#social-media .twitter.button');
  },

  hasBlogButton() {
    return this.isFound('#social-media .blog.button');
  },

  hasLoginLink() {
    return this.isFound('#header_login');
  },

  hasSignupLink() {
    return this.isFound('#header_signup');
  },

  hasCurrentUserDisplayName() {
    return this.isFound('#user_display_name').text();
  },

  getActiveIndex() {
    let $channels = this.isFound('li.js-carousel-nav');
    let $active = this.isFound('li.js-carousel-nav.active');
    return $channels.index($active);
  },

  activeChannelTitle: '#carousel h2 > a',

  getCarouselItem(index) {
    index = index + 1;
    return this.isFound(`li.js-carousel-nav:nth-child(${index})`);
  },

  ps4: {
    title: 'h2:contains(Top PS4 Channels)',
    allChannelsLink: 'a:contains(See all PS4 Channels)',
    streams: '#psFour-channels .stream.item .thumb a.cap[data-tt_content=top_psFour]',
    fullTitle: /Top PS4 Channels\s*Channels broadcasted from PlayStation 4/,
    videoGrid: '.video_grid.js-top-psFour'
  },

  xbox: {
    title: 'h2:contains(Top Xbox One Channels)',
    allChannelsLink: 'a:contains(See all Xbox One Channels)',
    streams: '#xbOne-channels .stream.item .thumb a.cap[data-tt_content=top_xbox]',
    fullTitle: /Top Xbox One Channels\s*Channels broadcasted from Xbox One/,
    videoGrid: '.video_grid.js-top-xbox'
  },

  live: {
    title: 'h2:contains(Top Live Channels)',
    streams: '#top-channels .stream.item .thumb a.cap[data-tt_content=top_channels]',
    allChannelsLink: 'a:contains(See all live Channels)',
    fullTitle: /Top Live Channels\s*Broadcasters people are watching now/
  },

  pulse: {
    title: 'h3:contains(Pulse)'
  }
});
