import computed from 'ember-computed';
import Base from 'web-client/tests/pages/base';
import { TEST_ATTR_PLAYLIST_ROW } from 'web-client/components/manager/collections/item-list-row/component';

export default Base.extend({
  name: 'twitch',
  id: 0,
  itemsSelector: `[data-test-selector="${TEST_ATTR_PLAYLIST_ROW}"]`,
  allCollectionsSelector: '.js-test-all-playlists',
  _url: computed('name', function() {
    return `/${this.get('name')}/manager/collections/${this.get('id')}`;
  }),

  items() {
    return find(this.get('itemsSelector'));
  },

  firstItemName() {
    return find(`${this.get('itemsSelector')}:first h5`).text();
  },

  itemNames() {
    return find(`${this.get('itemsSelector')} h5`).map((_,node) => node.textContent).toArray();
  },
  firstHandleSelector() {
    return '.playlist-editor-card__gripper:first';
  },
  lastHandleSelector() {
    return '.playlist-editor-card__gripper:last';
  },
  itemOptionSelector() {
    return '.playlist-editor-card__options';
  },
  collectionCardSelector() {
    return '.playlist-card';
  },
  firstHandle() {
    return find(this.firstHandleSelector());
  },
  lastHandle() {
    return find(this.lastHandleSelector());
  },
  firstHandleTop() {
    //Using it's card containers top (which should match) because sometimes the handle
    // is hidden
    return this.firstHandle().closest(this.collectionCardSelector()).offset().top;
  },
  lastHandleTop() {
    //Using it's card containers top (which should match) because sometimes the handle
    // is hidden
    return this.lastHandle().closest(this.collectionCardSelector()).offset().top;
  },
  close_nav() {
    let closeNavLink = find('#left_close');
    if (closeNavLink.length) {
      click(closeNavLink);
    }
  },
  rowHeight() {
    return this.firstHandle().closest(this.collectionCardSelector()).height();
  },
  rowEnd() {
    // Using row offset + width because the handle is sometimes hidden
    return this.firstHandle().closest(this.collectionCardSelector()).offset().left + this.firstHandle().closest(this.collectionCardSelector()).width();
  },
  forceHandleDisplay() {
    // Different window widths hide the drag handle. This could break if someone
    // changes the base display style from flex
    find(this.itemOptionSelector()).css({ display: 'flex' });
  }
});
