import computed from 'ember-computed';
import Base from 'web-client/tests/pages/base';
import {
  TEST_ATTR_CREATE_BUTTON,
  TEST_ATTR_FINALIZE_BUTTON,
  TEST_TITLE_INPUT_CLASS
} from 'web-client/components/manager/collections/create-button/component';
import {
  TEST_ATTR_PLAYLIST_TITLE
} from 'web-client/components/manager/collections/edit-container/component';

export default Base.extend({
  name: 'twitch',
  collectionsSelector: '[data-test-selector="playlist-index-row"]',
  createButtonSelector: `[data-test-selector="${TEST_ATTR_CREATE_BUTTON}"]`,
  finalizeButtonSelector: `[data-test-selector="${TEST_ATTR_FINALIZE_BUTTON}"]`,
  titleInputSelector: `.${TEST_TITLE_INPUT_CLASS}`,
  editCollectionTitleSelector: `[data-test-selector="${TEST_ATTR_PLAYLIST_TITLE}"]`,

  _url: computed('name', function() {
    return `/${this.get('name')}/manager/collections`;
  }),

  collections() {
    return find(this.get('collectionsSelector'));
  }
});
