import computed from 'ember-computed';
import Base from '../base';
import { EXTENSION_ID_VERSION_SEPARATOR } from 'web-client/adapters/extension';

export default Base.extend({
  extensionId: 'fake_extension',
  version: '1.0',

  _url: computed('extensionId', function () {
    let extensionId = encodeURIComponent(this.get('extensionId'));
    let version = encodeURIComponent(this.get('version'));
    return `/settings/extensions/${extensionId}${EXTENSION_ID_VERSION_SEPARATOR}${version}`;
  })
});
