import Base from '../base';

export default Base.extend({
  url(video) { return `/${this.username}/manager/v${video.id}/highlight`; },
  startTime: 'input.start-time',
  endTime: 'input.end-time',
  describe: 'button:contains(Describe Highlight)',
  name: 'input[name=title]',
  description: 'textarea[name=description]',
  submit: '.js-highlighter-action button',
  created: 'h4[data-test-highlight-created]',
  permalink: 'input[name=permalink]',
  embedPlayer: 'input[name=embed]'
});
