import Base from '../base';

export default Base.extend({
  url() {
    return `/${this.username}/manager/highlights`;
  },

  editVideoModalSelector: `.card-vod-edit`,
  editLinkSelector: `[data-test-selector=edit-button]`,
  editVideoTitleSelector: `.card-vod-edit input[name=vod-title]`,
  editVideoDescSelector: `.card-vod-edit textarea[name=vod-description]`,
  editVideoTagsSelector: `.card-vod-edit input[name=vod-tagList]`,
  editVideoDoneButtonSelector: `.buttons > .button[name=save]`,

  mainThumbnailSelector: `[data-test-video-form] .thumb img`,
  thumbnailsSelector: `[data-test-selectable-thumbnail]`,

  videoTitle() {
    return find('.video .card__title').text().trim();
  },

  videoDescription() {
    return find('.video .description').text().trim();
  },

  videoInfo() {
    return find('.video .card__info').text().trim();
  },

  editTitleVal() {
    return find(this.editVideoTitleSelector).val().trim();
  },

  editDescriptionVal() {
    return find(this.editVideoDescSelector).val().trim();
  },

  editTagsVal() {
    return find(this.editVideoTagsSelector).val().trim();
  },

  mainThumbnailSrc() {
    return find(this.mainThumbnailSelector).attr('src');
  },

  thumbnails() {
    return find(this.thumbnailsSelector);
  },

  clickEdit() {
    click(this.editLinkSelector);
  },

  editVideo({title, descriptionMarkdown, tags}) {
    andThen(() => {
      if (title) {
        fillIn(this.editVideoTitleSelector, title);
      }
      if (descriptionMarkdown) {
        fillIn(this.editVideoDescSelector, descriptionMarkdown);
      }
      if (tags) {
        fillIn(this.editVideoTagsSelector, tags);
      }
    });
  },

  hasEmptyMessage() {
    return find('[data-test-empty-message]').length === 1;
  }
});
