import Base from '../base';
import EmberObject from 'ember-object';

export default Base.extend({
  find(selector, context) {
    // For integration tests where the page is initialized with a scope.
    if (this.scope) {
      return this.scope.find(selector, context);
    }

    // For acceptance tests where a global find function is defined.
    return find(selector, context);
  },

  url() {
    return `/${this.username}/manager/uploads`;
  },

  hasVideoForm() {
    return this.find('[data-test-video-form]').length === 1;
  },

  titleField() {
    return '[data-test-video-form] [name=vod-title]';
  },

  descriptionField() {
    return '[data-test-video-form] [name=vod-description]';
  },

  languageField() {
    return '[data-test-video-form] #vod-selectbox-language';
  },

  gameField() {
    return '[data-test-video-form] #gameselector_input';
  },

  tagList() {
    return '[data-test-video-form] [name=vod-tagList]';
  },

  videoSelectionButton() {
    return '[data-test-file-picker-button]';
  },

  uploadVideoButton() {
    return '[data-test-schedule-upload-form] [data-test-upload-edit]';
  },

  saveVideoButton() {
    return '[data-test-video-form] [name=save]';
  },

  thumbnailUploadButton() {
    return '[data-test-video-form] [name=thumbnailUpload]';
  },

  removeCustomThumbnailButton() {
    return this.find('[data-test-remove-custom-thumbnail-button]');
  },

  publishStrategiesSelect() {
    return '[data-test-publish-strategies]';
  },

  viewableAtTimeInput() {
    return '[data-test-video-form] [data-test-time-picker-input]';
  },

  viewableAtDateInput() {
    return '[data-test-video-form] .pika-input';
  },

  publishDescription() {
    return this.find('[data-test-publish-description]').text().trim();
  },

  thumbnailsSrc() {
    return this.find('[data-test-selectable-thumbnail] img')
      .toArray()
      .map((el) => el.getAttribute('src'));
  },

  videoTitles() {
    return this.find('[data-test-video-title]')
      .toArray()
      .map((el) => el.textContent.trim());
  },

  thumbnailIsSelected(src) {
    return this.find('.modal__thumbnail-selected')
      .parent()
      .find('img')
      .attr('src') === src;
  },

  saveButton() {
    return '[data-test-video-form] [name=save]';
  },

  inProgressVideoCard() {
    return VideoCard.create({
      selector: '[data-test-videos-in-progress] [data-test-video-card]:first'
    });
  },

  firstPublishedVideoCard() {
    return VideoCard.create({
      selector: '[data-test-videos-published] [data-test-video-card]:first'
    });
  },

  fetchVideosErrorMessage() {
    return this.find('[data-test-fetch-videos-error-message]').text().trim();
  },

  hasPendingUploadsWarning() {
    return Boolean(this.find('[data-test-pending-uploads-warning]').length);
  },

  hasMustVerifyAccountNotice() {
    return Boolean(this.find('[data-test-must-verify-email-notice]').length);
  },

  confirmButtonSelector: '[data-test-confirm]',
  cancelButtonSelector: '[data-test-cancel]'
});

const VideoCard = EmberObject.extend({
  el() {
    return find(this.selector);
  },

  isPresent() {
    return this.el().length === 1;
  },

  status() {
    return this.el().attr('data-test-status');
  },

  uploadProgress() {
    return find('[data-test-percent-progress]', this.el()).text().trim();
  },

  editButtonSelector() {
    return [this.selector, '[data-test-selector=edit-button]'].join(' ');
  },

  thumbnailSrc() {
    return find('[data-test-thumbnail]', this.el()).attr('src');
  },

  moreMenuButton() {
    return [this.selector, '[data-test-selector=more-menu-button]'].join(' ');
  },

  deleteButton() {
    return [this.selector, '[data-test-selector=delete-button]'].join(' ');
  }
});
