import Base from './base';

export default Base.extend({
  _url: '/directory/all',

  hasUnread(count = 1) {
    return this.isFound(`.total-unread:contains(${count})`);
  },

  icon() {
    return 'a.conversations-list-icon';
  },

  emoticonSelectorToggle() {
    return '.emoticon-selector-toggle';
  },

  emoticonFilter() {
    return '.js-filter-input';
  },

  hasSenderName(name = 'friend') {
    return this.isFound(`.conversation-details .conversation-name:contains(${name})`);
  },

  hasMessagePreview(text = 'test message') {
    return this.isFound(`.conversation-details .conversation-preview:contains(${text})`);
  },

  hasMessage(text) {
    return this.isFound(`.conversation-chat-line .message:contains(${text})`);
  },

  searchResultSelector(name) {
    return `.conversations-list-item .conversation-name:contains(${name})`;
  },

  searchResult(name) {
    return this.isFound(`.conversations-list-item .conversation-name:contains(${name})`);
  },

  fillInSearch(userName) {
    let selector = '.conversations-list-search-bar input';
    fillIn(selector, userName);
  },

  fillInChat(message) {
    let selector = 'textarea.chat_text_input';
    fillIn(selector, message);
    keyEvent(selector, 'keydown', this.keyCodes.enter);
  }
});
