/* eslint-disable no-console */

import resolver from './helpers/resolver';
import {
  setResolver
} from 'ember-qunit';
import QUnit from 'qunit';
import run from 'ember-runloop';
import CookieMock from './helpers/cookie-mock';
import LegacyStorageMock from './helpers/cookie-mock';
import {
  setup as setupAsyncAds,
  teardown as teardownAsyncAds
} from './helpers/mock-async-ads';
import {
  setup as setupTracking,
  teardown as teardownTracking
} from './helpers/mock-tracking';
import {
  setup as setupIdsForMixpanel,
  teardown as teardownIdsForMixpanel
} from './helpers/mock-ids-for-mixpanel';
import fixQUnitParams from './helpers/fix-qunit-params';
import config from 'web-client/config/environment';
import VodAppeal from 'web-client/models/vod-appeal';
import ChannelViewer from 'web-client/models/channel-viewer';
import { setShouldRetry } from 'ember-graceful-retry/test-helpers';
import { setOwnerInjection } from 'web-client/utilities/owner-injection';
import { stubLogout } from './helpers/stub-login';

// kick off the various ext reopens
import 'web-client/tests/helpers/force-super';
import 'web-client/app';
import 'web-client/tests/helpers/assert-interactivity';
import 'web-client/tests/helpers/assert-track-event';
import 'web-client/tests/helpers/assert-string-includes';
import 'web-client/tests/helpers/assert-helpers';
import 'web-client/tests/helpers/assert-did-notify';
import 'web-client/tests/helpers/assert-did-notify';
import 'web-client/tests/helpers/assert-dates-match';

// register async test helpers:
import 'web-client/tests/helpers/choose-file';
import 'web-client/tests/helpers/mock-web-sockets';
import 'web-client/tests/helpers/scroll-top';

// register waiters
import 'web-client/tests/helpers/waiters/idle-callback';
import 'web-client/tests/helpers/waiters/loader-waiter';


setResolver(resolver);

fixQUnitParams(QUnit);

[window.localStorage, window.sessionStorage].forEach(storage => {
  if (!storage) {
    return;
  }

  let previousValues = {};

  QUnit.begin(function () {
    Object.keys(storage).forEach(key => {
      previousValues[key] = storage.getItem(key);
    });
    storage.clear();
    setupAsyncAds();
    setupTracking();
    setupIdsForMixpanel();
  });

  QUnit.testDone(function () {
    teardownIdsForMixpanel();
    teardownTracking();
    storage.clear();
    teardownAsyncAds();
    run(() => {
      VodAppeal.resetCache();
    });
    ChannelViewer.reset();
  });

  QUnit.testStart(function () {
    Object.keys(previousValues).forEach(key => {
      storage.setItem(key, previousValues[key]);
    });
  });
});

let previousCookie, previousLegacyStorage;
QUnit.begin(function () {
  previousCookie = window.cookie;
  previousLegacyStorage = window.Twitch.storage.legacy;
  window.Twitch.storage.legacy = new LegacyStorageMock();
  window.cookie = new CookieMock();
});

QUnit.testDone(function () {
  window.Twitch.storage.legacy = new LegacyStorageMock();
  window.cookie = new CookieMock();
});

// FIXME: done callbacks fire multiple times. Could not reproduce this with
// a plain QUnit jsbin.
let hasDone = false;
QUnit.done(function () {
  if (hasDone) {
    return;
  }
  hasDone = true;
  window.cookie = previousCookie;
  window.Twitch.storage.legacy = previousLegacyStorage;
});

if (config.APP.LOG_TEST_START_STOP) {
  QUnit.testStart(function(test) {
    let module = test.module ? test.module : '';
    console.log(`# ${module} ${test.name}: started.`);
  });

  QUnit.testDone(function(test) {
    let module = test.module ? test.module : '';
    console.log(`# ${module} ${test.name}: done.`);
    console.log('####');
  });
}

QUnit.testStart(function() {
  setShouldRetry(false);
  setOwnerInjection(null);
  stubLogout();
});
