import { moduleFor } from 'ember-qunit';
import test from 'ember-sinon-qunit/test-support/test';

moduleFor('adapter:game-detail', 'Unit | Adapter | game detail', {
  needs: [
    'service:api',
    'service:session'
  ],
  beforeEach() {
    this.adapter = this.subject();
  }
});

test('test queryRecord', function (assert) {
  let api = this.adapter.get('api');
  let store = 'store';
  let stub = this.stub(api, 'request', function () {
    return store;
  });

  this.adapter.queryRecord(store, 'game-detail', {game: 'test game'});

  assert.ok(stub.calledOnce, 'request was called');
});
