import { moduleFor } from 'ember-qunit';
import test from 'ember-sinon-qunit/test-support/test';

moduleFor('adapter:manager/past-broadcast-video', 'Unit | Adapter | manager/past broadcast video', {
  needs: [
    'service:api',
    'service:session'
  ],
  beforeEach() {
    this.adapter = this.subject();
  }
});

test('test query', function(assert) {
  let api = this.adapter.get('api');
  let store = 'store';
  let stub = this.stub(api, 'request', function () {
    return store;
  });

  this.adapter.query(store, 'past-broadcast-video', {channel: 'test'});

  assert.ok(stub.calledOnce, 'request was called');
});
