import { moduleFor } from 'ember-qunit';
import test from 'ember-sinon-qunit/test-support/test';

moduleFor('adapter:presence-settings', 'Unit | Adapter | settings', {});

test('urlForUpdateRecord', function (assert) {
  let adapter = this.subject();
  let foo = 'foo';
  let name = 'bar';
  let stub = this.stub(adapter, '_buildURL', function () {
    return foo;
  });

  let result = adapter.urlForUpdateRecord(1234, name);

  assert.ok(stub.calledOnce, '_buildURL was called');
  let { args } = stub.firstCall;
  assert.equal(args.length, 1, '1 arg passed to _buildURL');
  assert.equal(args[0], name, 'modelName passed to _buildURL');
  assert.equal(result, foo, 'result of _buildURL returned');
});
