import { moduleForComponent, test } from 'ember-qunit';
import Helper from 'ember-helper';

let targetObject;

moduleForComponent('chat/ignore-form', 'Ignore Form Component', {
  needs: ['template:svg/close'],

  setup() {
    this.register('helper:i18n', Helper.helper(([value]) => value));
  }
});

test('it works!', function (assert) {
  assert.ok(this.subject());
});

test('displays username', function (assert) {
  this.subject({ username: 'Extalix' });

  assert.equal(this.$('.text-content .content-header h4').text().trim(), 'Ignore Extalix');
});

test('clicking send button does not fire sendReason action if option 0 is selected', function (assert) {
  assert.expect(1);

  targetObject = {
    actionFunc() {
      assert.ok(false, 'should not have fired sendReason action with option 0 selected');
    }
  };

  this.subject({ targetObject, sendReason: 'actionFunc' });

  assert.equal(this.$('.reason-select select').val(), '0');
  this.$('.qa-ignore__button').click();
});

test('clicking send button without selecting non zero option displays error', function (assert) {
  this.subject();

  this.$('.qa-ignore__button').click();
  assert.equal(this.$('.reason-select .header .error').text().trim(), 'Please select a reason');
});

test('clicking send button fires sendReason if a nonzero option is selected', function (assert) {
  assert.expect(2);

  targetObject = {
    sendFunc(reason) {
      assert.equal(reason, 'Spam');
      assert.ok(true, 'yay we got sendReason action');
    }
  };

  this.subject({ targetObject, sendReason: 'sendFunc' });
  this.$('.reason-select select option').removeAttr('selected');
  this.$('.reason-select select option[value="Spam"]').attr('selected', true);
  this.$('.qa-ignore__button').click();
});
