/* global expect */
import { assign } from 'ember-platform';
import RSVP from 'rsvp';
import { moduleForComponent } from 'ember-qunit';
import { skip } from 'qunit';
import { JTV_USER_PICTURES_404_USER_150X150_URL } from 'web-client/utilities/urls/static-cdn';
import { helper } from 'ember-helper';

moduleForComponent('chat/moderation-card', 'Moderation Card Component', {
  needs: [
    'template:svg/close',
    'template:svg/ignore',
    'template:svg/unignore',
    'template:svg/timeout',
    'template:svg/ban',
    'template:svg/op'
  ],
  setup: function () {
    this.owner.register('helper:follow-button', helper(function() {}));
    // --------
    // TODO: REMOVE WHEN FRIENDS LIST IS OUT OF STAFF BETA
    window.Twitch = {
      user: function () {
        return RSVP.resolve({});
      }
    };
    // --------
    this.getComponent = function (args) {
      let defaultCardInfo = {
      };
      return this.subject({cardInfo: assign(defaultCardInfo, args)});
    };

    this.testAction = function (assert, component, actionName, testMessage) {
      let targetObj = {
        actionFunc: function () {
          assert.ok(true, testMessage);
        }
      };
      component.set('targetObject', targetObj);
      component.set(actionName, 'actionFunc');
    };

    this.testActionWithUser = function (assert, component, actionName, user, testMessage) {
      let targetObj = {
        actionFunc: function (data) {
          assert.equal(data.user, user);
          assert.ok(true, testMessage);
        }
      };
      component.set('targetObject', targetObj);
      component.set(actionName, 'actionFunc');
    };
  }
});

skip('it works!', function (assert) {
  assert.ok(this.getComponent());
});

skip('clicking close fires closeModerationCard', function (assert) {
  let component = this.getComponent();
  this.testAction(assert, component, 'closeAction', 'closeAction was fired');
  this.$().find('.close-button').click();
});

skip('profile banner has user profile background', function (assert) {
  this.getComponent({
    user: {
      profile_banner_background_color: '#012'
    }
  });
  assert.equal(this.$().find('.card-header').attr('style'), 'background-color: #012');
});

skip('if user is ignored then unignore button is shown', function (assert) {
  this.getComponent({isIgnored: true});
  assert.equal(this.$().find('button.ignore').attr('title'), 'Unignore User');
});

skip('clicking ignore ignores user', function (assert) {
  let component = this.getComponent({user: {id: '2fast2furious'}});
  this.testActionWithUser(assert, component, 'ignoreAction', '2fast2furious', 'ignoreAction was fired');
  this.$().find('button.ignore').click();
});

skip('clicking unignore unignores user', function (assert) {
  let component = this.getComponent({user: {id: '2fast2furious'}, isIgnored: true});
  this.testActionWithUser(assert, component, 'unignoreAction', '2fast2furious', 'unignoreAction was fired');
  this.$().find('button.ignore').click();
});

skip('if moderator then ban, mod, and timeout buttons are available', function (assert) {
  this.getComponent({isModeratorOrHigher: true});
  assert.ok(this.$().find('.mod-controls'));
  assert.ok(this.$().find('button.timeout'));
  assert.ok(this.$().find('button.ban'));
  assert.ok(this.$().find('button.mod'));
});

skip('clicking message fires messageaction', function (assert) {
  let component = this.getComponent({user: {name: 'Extalix'}});
  this.testActionWithUser(assert, component, 'messageAction', 'Extalix', 'messageAction was fired');
  this.$().find('.message-button').click();
});

skip('clicking banuser bans user', function (assert) {
  let component = this.getComponent({user: {id: 'Extalix'}, isModeratorOrHigher: true});
  this.testActionWithUser(assert, component, 'banAction', 'Extalix', 'banAction was fired');
  this.$().find('button.ban').click();
});

skip('clicking moduser mods user', function (assert) {
  let component = this.getComponent({user: {id: 'Extalix'}, isModeratorOrHigher: true});
  this.testActionWithUser(assert, component, 'modAction', 'Extalix', 'modAction was fired');
  this.$().find('button.mod').click();
});

skip('clicking timeout user times out user', function (assert) {
  let component = this.getComponent({user: {id: 'Extalix'}, isModeratorOrHigher: true});
  this.testActionWithUser(assert, component, 'timeoutAction', 'Extalix', 'timeoutAction was fired');
  this.$().find('button.timeout').click();
});

skip('if user has profile pic, it is displayed', function (assert) {
  this.getComponent({user: {logo: 'funnypics.twitch.tv'}});
  assert.equal(this.$().find('img.channel_logo').attr('src'), 'funnypics.twitch.tv');
});

skip('if user does not have a profile pic, default is used', function (assert) {
  this.getComponent();
  assert.equal(this.$().find('img.channel_logo').attr('src'), JTV_USER_PICTURES_404_USER_150X150_URL);
});

skip('tracking action is fired when moderation card is initialized', function (assert) {
  expect(2);
  let targetObj = {
    trackFunc: function (eventName) {
      assert.equal(eventName, 'chat_card_open');
      assert.ok(true, 'tracked!');
    }
  };
  this.subject({trackAction: 'trackFunc', targetObject: targetObj});
});

skip('tracking action is fired whenever user id changes', function (assert) {
  expect(4);
  let targetObj = {
    trackFunc: function (eventName) {
      assert.equal(eventName, 'chat_card_open');
      assert.ok(true, 'got initial track event');
    },
    trackFunc2: function (eventName) {
      assert.equal(eventName, 'chat_card_open');
      assert.ok(true, 'got second track event');
    }
  };
  let component = this.subject({trackAction: 'trackFunc', targetObject: targetObj, cardInfo: {user: {id: 'firstguy'}}});

  component.set('trackAction', 'trackFunc2');
  component.set('cardInfo.user.id', 'newguy');
});

skip('when moderation card is initialized, it is offset by rendertop and renderleft values', function (assert) {
  this.getComponent({renderTop: 123, renderLeft: 456});
  assert.deepEqual(this.$().offset(), {top: 123, left: 456});
});

skip('when rendertop and renderleft change, moderation card position also changes', function (assert) {
  let component = this.getComponent({renderTop: 123, renderLeft: 456});
  assert.notDeepEqual(this.$().offset(), {top: 111, left: 222});
  component.set('cardInfo.renderTop', 111);
  component.set('cardInfo.renderLeft', 222);
  assert.deepEqual(this.$().offset(), {top: 111, left: 222});
});
