import { assign } from 'ember-platform';
import { moduleForComponent } from 'ember-qunit';
import { skip } from 'qunit';

moduleForComponent('chat/whisper-line', 'Whisper Line Component', {
  unit: true,

  setup: function () {
    this.getComponent = function (args) {
      let defaultInfo = {
        color: '#FF7F50',
        from: 'Extalix',
        message: 'Secret whisper!',
        style: 'whisper',
        date: new Date(),
        labels: ['owner', 'mod', 'turbo', 'staff'],
        tags: { emotes: {} },
        to: 'NotMLee',
        toColor: '#FF0000'
      };

      return this.subject({msgObject: assign(defaultInfo, args)});
    };
  }
});

skip('it works!', function (assert) {
  assert.ok(this.getComponent());
});

skip('if whisper is coming from an admin, show the admin badge', function (assert) {
  this.getComponent({labels: ['admin']});
  assert.ok(this.$().find('.badges .admin'));
});

skip('if whisper is coming from a staff member, show the staff badge', function (assert) {
  this.getComponent({labels: ['staff']});
  assert.ok(this.$().find('.badges .staff'));
});

skip('if whisper is coming from a global mod, show the global mod badge', function (assert) {
  this.getComponent({labels: ['global_mod']});
  assert.ok(this.$().find('.badges .global-moderator'));
});
