import { moduleForComponent, test } from 'ember-qunit';

let sendEmailToSubscribersModal;

moduleForComponent(
  'dashboards/revenue/send-email-to-subscribers-modal',
  'Unit | Component | dashboards/revenue/send email to subscribers modal',
  {
    unit: true
  }
);

test('passed-in properties', function (assert) {
  assert.expect(2);

  sendEmailToSubscribersModal = this.subject();

  assert.equal(sendEmailToSubscribersModal.get('closeModal'), null, `"closeModal" defaults to null`);
  assert.equal(sendEmailToSubscribersModal.get('subscriberCount'), null, `"subscriberCount" defaults to null`);
});

test('own properties', function (assert) {
  assert.expect(6);

  sendEmailToSubscribersModal = this.subject();

  assert.equal(sendEmailToSubscribersModal.get('emailBody'), '', `"emailBody" defaults to empty string`);
  assert.equal(sendEmailToSubscribersModal.get('emailTitle'), '', `"emailTitle" defaults to empty string`);

  assert.equal(
    sendEmailToSubscribersModal.get('hasAttemptedClosingModalWithoutSending'),
    false,
    `"hasAttemptedClosingModalWithoutSending" defaults to false`
  );

  assert.equal(
    sendEmailToSubscribersModal.get('hasSendingEmailToSubscribersErrored'),
    false,
    `"hasSendingEmailToSubscribersErrored" defaults to false`
  );

  assert.equal(
    sendEmailToSubscribersModal.get('hasSentEmailToSubscribersSuccessfully'),
    false,
    `"hasSentEmailToSubscribersSuccessfully" defaults to false`
  );

  assert.equal(
    sendEmailToSubscribersModal.get('isSendingEmailToSubscribers'),
    false,
    `"isSendingEmailToSubscribers" defaults to false`
  );
});

test(`"isSendingEmailToSubscribersDisabled" computed property`, function (assert) {
  assert.expect(4);

  sendEmailToSubscribersModal = this.subject();

  assert.ok(
    sendEmailToSubscribersModal.get('isSendingEmailToSubscribersDisabled'),
    `"isSendingEmailToSubscribersDisabled" defaults to true as "emailBody" and "emailTitle" are empty strings`
  );

  sendEmailToSubscribersModal.set('emailBody', 'email body!');

  assert.ok(
    sendEmailToSubscribersModal.get('isSendingEmailToSubscribersDisabled'),
    `"isSendingEmailToSubscribersDisabled" is computed to still be true`
  );

  sendEmailToSubscribersModal.set('emailTitle', 'email title!');

  assert.notOk(
    sendEmailToSubscribersModal.get('isSendingEmailToSubscribersDisabled'),
    `"isSendingEmailToSubscribersDisabled" is computed to be false`
  );

  sendEmailToSubscribersModal.set('emailBody', '');
  sendEmailToSubscribersModal.set('emailTitle', '');

  assert.ok(
    sendEmailToSubscribersModal.get('isSendingEmailToSubscribersDisabled'),
    `"isSendingEmailToSubscribersDisabled" is computed to be true`
  );
});

test(`"closeModal" action sets "hasAttemptedClosingModalWithoutSending" to true with email body`, function (assert) {
  assert.expect(1);

  let closeModalAction;

  sendEmailToSubscribersModal = this.subject({ emailBody: 'email body!' });

  closeModalAction = sendEmailToSubscribersModal.send('closeModal');

  assert.notOk(closeModalAction, `"isSendingEmailToSubscribersDisabled" is computed to be false`);
});
