import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import { getTimeSeriesData } from 'web-client/mirage/fixtures/video-stats-timeseries';
import DetailsReport from 'web-client/utilities/video-stats/details-report';

const TODAY = new Date(1991, 3, 7);

moduleForComponent('dashboards/video-stats/details', 'Unit | Component | dashboards/video-stats/details', {
  unit: true,
  beforeEach() {
    this.report = DetailsReport.create({
      today: TODAY,
      data: getTimeSeriesData()
    });

    this.component = this.subject({
      today: TODAY,
      report: this.report
    });
  }
});

test('formatLineChartData', function(assert) {
  let dataSet = [{ x: 12, y: 14 }];
  let chartDataSets = { foo: dataSet };
  let lineChartData = this.component.formatLineChartData(chartDataSets);

  assert.deepEqual(lineChartData.labels, [12], 'should properly parse out labels');
  assert.ok(lineChartData.datasets[0].data, 'datasets should not be empty');
});

test('formatLineData', function(assert) {
  let dataSet = { data: [] };
  let lineData = this.component.formatLineData('viewcount', 5, dataSet);

  assert.ok(lineData, 'should return line data');
  assert.equal(lineData.label, 'View Count', 'should properly set a label');
});
