import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import { copy } from 'ember-metal/utils';

let championFilter;

const CHAMP_DATA = [
  {
    "key": "Aatrox",
    "name": "Aatrox",
    "spriteSrc": "https://ddragon.leagueoflegends.com/cdn/6.15.1/img/sprite/champion0.png",
    "spriteWidth": 48,
    "spriteHeight": 48,
    "spritePos": "-0px -0px",
    "tags": {
      "fighter": true,
      "tank": true
    }
  },
  {
    "key": "Ahri",
    "name": "Ahri",
    "spriteSrc": "https://ddragon.leagueoflegends.com/cdn/6.15.1/img/sprite/champion0.png",
    "spriteWidth": 48,
    "spriteHeight": 48,
    "spritePos": "-48px -0px",
    "tags": {
      "mage": true,
      "assassin": true
    }
  },
  {
    "key": "Akali",
    "name": "Akali",
    "spriteSrc": "https://ddragon.leagueoflegends.com/cdn/6.15.1/img/sprite/champion0.png",
    "spriteWidth": 48,
    "spriteHeight": 48,
    "spritePos": "-96px -0px",
    "tags": {
      "assassin": true
    }
  }
];

moduleForComponent('directory/lol-metadata/champion-filter', 'champion-filterasdf', {
  unit: true,
  beforeEach() {
    championFilter = this.subject({
      // serializedChampData: CHAMP_DATA,
      lolMetadataFilter: {
        champTags: {'fighter': true, 'tank': true, 'mage': true, 'assassin': true},
        serializedChampData: CHAMP_DATA
      }
    });
  }
});

test('ChampionFilter component initializes', function (assert) {
  assert.ok(championFilter);
});

test ('Searching filters champions correctly', function (assert) {
  assert.expect(6);

  let have, want;

  let styledChampData = CHAMP_DATA.map(champ => {
    let c = copy(champ);
    c.figureStyle = championFilter._figureStyle(champ);
    c.imgStyle = championFilter._imgStyle(champ);
    return c;
  });

  championFilter.set('champQuery', 'a');
  have = championFilter.get('filteredChamps');
  want = styledChampData;
  assert.deepEqual(have, want, 'prefix searching');

  championFilter.set('champQuery', 'k');
  have = championFilter.get('filteredChamps');
  want = [styledChampData[2]];
  assert.deepEqual(have, want, 'matches not just prefix');

  championFilter.set('champQuery', 'ai');
  have = championFilter.get('filteredChamps');
  want = [styledChampData[1], styledChampData[2]];
  assert.deepEqual(have, want, 'fuzzy searching');

  championFilter.set('champQuery', 'AI');
  have = championFilter.get('filteredChamps');
  want = [styledChampData[1], styledChampData[2]];
  assert.deepEqual(have, want, 'fuzzy searching agnostic to casing');

  championFilter.set('champQuery', 'AI');
  have = championFilter.get('filteredChamps');
  want = [styledChampData[1], styledChampData[2]];
  assert.deepEqual(have, want, 'fuzzy searching agnostic to casing');

  championFilter.set('champQuery', 'assassin');
  have = championFilter.get('filteredChamps');
  want = [styledChampData[1], styledChampData[2]];
  assert.deepEqual(have, want, 'champion roles');
});
