import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';

moduleForComponent('intl/string-yield', 'Unit | Component | intl/string-yield', {
  unit: true
});

test('Intl.formatMessage() is called instead of Intl.t()', function (assert) {
  let translatedString = 'a translation string';
  assert.expect(2);

  let intl = {
    t(/* key, options */) {
      assert.fail('This should not be called');
    },
    formatMessage(message /*, options */) {
      assert.strictEqual(message, translatedString);
      return message;
    }
  };

  let component = this.subject({
    intl: intl,
    key: translatedString
  });

  assert.strictEqual(component.get('translation'), translatedString);
});
