import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import {test} from 'ember-qunit';

moduleForComponent('intl/t-yield', 'Unit | Component | intl/t-yield', {
  unit: true
});

test('Dynamic yields can support single string', function(assert) {
  let subject = this.subject({
    intl: {},
    key: 'translation.key',
    args: {
      name: 'Timmy',
      randomComponent: {}
    },
    dynamicYields: 'game'
  });

  assert.deepEqual(subject.get('_dynamicYields'), {args: ['game'], xTags: []});
});

test('Expected outputs for complex translation', function (assert) {
  assert.expect(11);
  let intl = {
    t(key, options) {
      if (key === 'translation.key') {
        assert.ok(true, 't invoked with correct key');
        assert.strictEqual(options.name, 'Timmy', 'correct string args are passed');
        assert.strictEqual(options.game, '{game}', 'passing correct placeholder for dynamic yield for an arg');
        assert.strictEqual(options.anotherGame, '{anotherGame}', 'passing correct placeholder for dynamic yield inside xTag');
        return `{randomComponent} Hey Timmy started watching \{game\}? <x:link>Click here to learn more about \{anotherGame\}</x:link>`;
      }
    },
    formatMessage() {
      assert.fail('This should not be called');
      return 'formatted string';
    }
  };

  let subject = this.subject({
    intl: intl,
    key: 'translation.key',
    args: {
      name: 'Timmy',
      randomComponent: {}
    },
    dynamicYields: ['game', 'x:link', 'anotherGame']
  });

  assert.deepEqual(subject.get('_dynamicYields.args'), ['game', 'anotherGame'], 'Dynamic Yields - Args');
  assert.deepEqual(subject.get('_dynamicYields.xTags'), ['x:link'], 'Dynamic Yields - XTags');
  assert.deepEqual(subject.get('_args.strings'), {'name': 'Timmy'}, 'Args - Strings');
  assert.deepEqual(subject.get('_args.components'), {randomComponent:{}}, 'Args - Components');

  assert.strictEqual(subject.get('_yieldArgToPlaceholder.game'), '{game}', 'Yield Arg to Placeholder');
  assert.strictEqual(subject.get('translation'),
      '{randomComponent} Hey Timmy started watching {game}? <x:link>Click here to learn more about {anotherGame}</x:link>',
      'Translation Matches'
  );

  assert.deepEqual(subject.get('fragments'),
      [{
        'type':'component',
        'component': {},
        'name': 'randomComponent'
      },{
        'type':'text',
        'text':' Hey Timmy started watching '
      },{
        'type':'yield',
        'name':'game',
        'text':'game'
      },{
        'type':'text',
        'text':'? '
      },{
        'type':'yield',
        'name':'x:link',
        'text':'Click here to learn more about {anotherGame}'
      }],
      'Correct fragments are generated'
  );
});
