import moment from 'moment';
import { moduleForComponent, test } from 'ember-qunit';

moduleForComponent('relative-time', 'Unit | Component | relative-time', {
  // Specify the other units that are required for this test
  // needs: ['component:foo', 'helper:bar'],
  unit: true
});

test('when given a date', function(assert) {
  let component = this.subject();
  component.set('date', moment().toISOString());
  this.render();
  assert.equal(this.$().text().trim(), 'a few seconds ago', 'renders a dateString');
});

test('when given a date less than 24 hours ago', function(assert) {
  let component = this.subject();
  component.set('date', moment().toISOString());
  assert.equal(component.get('dateString'), moment().fromNow(), 'should display a relative time');
});

test('when given a date more than 24 hours ago', function(assert) {
  let component = this.subject();
  component.set('date', '2015-11-04T21:55:58Z');
  assert.equal(component.get('dateString'), moment('2015-11-04T21:55:58Z').format('MMM D, YYYY'), 'should display an absolute time');
});


test('when given a sameYearFormat property', function(assert) {
  let component = this.subject({
    'date': moment().subtract(1, 'days').toISOString()
  });
  component.set('sameYearFormat', 'MMM D');
  assert.equal(component.get('dateString'),  moment().subtract(1, 'days').format('MMM D'), 'should display an absolute time excluding year');
});

test("when the date isn't from the current year and a differentYearFormat is specified", function(assert) {
  let component = this.subject();
  component.set('date', '2014-11-04T21:55:58Z');
  component.set('differentYearFormat', 'MMM DD, YYYY');
  assert.equal(component.get('dateString'), moment('2014-11-04T21:55:58Z').format('MMM DD, YYYY'), 'should display an absolute time in MMM DD, YYYY format');
});


test('when given a relativeDayCutoff property in days', function(assert) {
  let twoWeeksAgo = moment().subtract(13, 'days');
  let component = this.subject({
    'date': twoWeeksAgo.toISOString(),
    'relativeDayCutoff': 14
  });
  assert.equal(component.get('dateString'), twoWeeksAgo.fromNow(), 'should display a relative time within 14 days');

  component.set('date', '2015-11-04T21:55:58Z');
  component.set('relativeDayCutoff', Infinity);
  assert.equal(component.get('dateString'), moment('2015-11-04T21:55:58Z').fromNow(), 'should always display a relative time');
});
