import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';

/*
  Track:
    id
    title
    performer
    offset
    duration
    is_muted
    track_appeal:
      status
      reason
*/

let mutedTrack;

moduleForComponent('video/appeals/muted-track', 'Integration | Component | video/appeals/muted-track', {
  unit: true,
  beforeEach() {
    mutedTrack = this.subject({
      pendingTracks: true,
      track: {
        "id": 1,
        "title": "song title",
        "performer": "song performer",
        "offset": 0,
        "duration": 180,
        "is_muted": true,
        "track_appeal": null
      }
    });
  }
});

test("MutedTrackComponent initializes", function (assert) {
  assert.ok(mutedTrack);
});

test("Can appeal a track if muted and an appeal does not exist", function (assert) {
  assert.ok(mutedTrack.get('canAppealTrack'));
});

test("Can't appeal track if not muted", function (assert) {
  mutedTrack.set('track.is_muted', false);
  assert.ok(!mutedTrack.get('canAppealTrack'));
});

test("Can't appeal a track if an appeal already exists", function (assert) {
  mutedTrack.set('track.track_appeal', {});
  assert.ok(!mutedTrack.get('canAppealTrack'));
});

test("Always renders track when selecting tracks", function (assert) {
  assert.ok(!mutedTrack.get('shouldRenderTrack'));

  mutedTrack.set('selectTracks', true);
  assert.ok(mutedTrack.get('shouldRenderTrack'));
});

test("Does not render track when viewing selected tracks and no reason was selected", function (assert) {
  assert.ok(!mutedTrack.get('shouldRenderTrack'));

  mutedTrack.set('selectedTracks', true);
  assert.ok(!mutedTrack.get('shouldRenderTrack'));
});

test("Renders track when viewing selected tracks and a reason was selected", function (assert) {
  assert.ok(!mutedTrack.get('shouldRenderTrack'));

  mutedTrack.set('selectedTracks', true);
  mutedTrack.set('track.reasonForAppealing', 'incorrect_match');
  assert.ok(mutedTrack.get('shouldRenderTrack'));
});

test("Does not render track when viewing pending tracks and track does not have a pending appeal", function (assert) {
  mutedTrack.set('pendingTracks', true);
  assert.ok(!mutedTrack.get('shouldRenderTrack'));
});

test("Renders track when viewing pending tracks and track has a pending appeal", function (assert) {
  mutedTrack.set('pendingTracks', true);
  mutedTrack.set('track.track_appeal', {status: 'pending'});
  assert.ok(mutedTrack.get('shouldRenderTrack'));
});

test("Renders track when viewing pending tracks and track has a reason for appealing", function (assert) {
  mutedTrack.set('pendingTracks', true);
  mutedTrack.set('track.reasonForAppealing', 'incorrect_match');
  assert.ok(mutedTrack.get('shouldRenderTrack'));
});

test("Displays the right reason for appealing", function (assert) {
  mutedTrack.set('track.track_appeal', {reason: 'incorrect_match'});
  assert.equal(mutedTrack.get('selectedReason'), "My video does not contain the audio identified");
});
