import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';

const maxVodsPerRow = 3;

moduleForComponent('video/coviews/directory-container', 'Unit | Component | video/coviews/directory-container', {
  unit: true,
  beforeEach() {
    this.videoCoviews = this.subject({
      maxVodsPerRow: maxVodsPerRow,
      vodCoviews: { hadRecs: true }
    });
  }
});

test('initializing the component', function(assert) {
  assert.ok(this.videoCoviews, 'should work successfully');
});

test("Only shows max viewable vods", function(assert) {
  assert.expect(2);
  this.videoCoviews.set('recommendedVods', [
    {channel: {name: 'charishaxd'}},
    {channel: {name: 'charishaxd'}},
    {channel: {name: 'charishaxd'}},
    {channel: {name: 'charishaxd'}}
  ]);

  assert.equal(this.videoCoviews.get('numRecsViewable'), maxVodsPerRow);
  assert.equal(this.videoCoviews.get('recommendedVodsToShow').length, maxVodsPerRow);
});

test("Tracking Coview Recommenation works for forced variety - Max Channels", function(assert) {
  let vods = [
    {id: 1, channel: {name: 'charishaxd'}, game: 'league of legends'},
    {id: 3, channel: {name: 'charishaxd'}, game: 'dota'},
    {id: 4, channel: {name: 'charishaxd'}, game: 'league of legends'},
    {id: 6, channel: {name: 'chirashii'}, game: 'overwatch'},
    {id: 7, channel: {name: 'chirashii'}, game: 'overwatch'}
  ];
  this.videoCoviews.set('recommendedVods', vods);
  this.videoCoviews.set('vodCoviews.forcedVarietyMaxChannelsBoundary', 4);

  let have = this.videoCoviews._buildCoviewRecommendationTrackingObj();
  let want = {
    had_recs: true,
    num_recs_made: 5,
    num_recs_viewable: maxVodsPerRow,
    rec_list: "1,3,4,6,7",
    forced_variety_max_channels_boundary: 4,
    unique_games_total: 3,
    unique_channels_total: 2,
    unique_games_top_8: 3,
    unique_channels_top_8: 2,
    unique_games_viewable: 2,
    unique_channels_viewable: 1
  };

  assert.expect(Object.keys(want).length);
  Object.keys(want).forEach(key => {
    if (want[key] === null) {
      assert.notOk(have[key]);
    } else {
      assert.deepEqual(have[key], want[key], `Tracking object key: ${key}`);
    }
  });
});

test("Tracking Coview Remove Rec Works", function(assert) {
  let vods = [
    {id: 1, channel: {name: 'charishaxd'}, game: 'league of legends'},
    {id: 3, channel: {name: 'charishaxd'}, game: 'dota'},
    {id: 4, channel: {name: 'charishaxd'}, game: 'league of legends'},
    {id: 6, channel: {name: 'chirashii'}, game: 'overwatch'},
    {id: 7, channel: {name: 'chirashii'}, game: 'overwatch'}
  ];
  let vod = {id: 3, channel: {name: 'charishaxd'}, game: 'dota'};
  let position = 2;

  this.videoCoviews.set('recommendedVods', vods);

  let have = this.videoCoviews._buildRemoveRecommendationTrackingObj(vod, position);
  let want = {
    vod_id: 3,
    position: 2,
    channel: 'charishaxd',
    game: 'dota',
    num_recs_viewable: 3
  };

  assert.expect(Object.keys(want).length);
  Object.keys(want).forEach(key => {
    if (want[key] === null) {
      assert.notOk(have[key]);
    } else {
      assert.deepEqual(have[key], want[key], `Tracking object key: ${key}`);
    }
  });
});
