import { moduleFor, test } from 'ember-qunit';
import sinon from 'sinon';

moduleFor('controller:application', 'Unit | Controller | application', {
  integration: true
});

[
  { currentPath: 'index', isMobile: true, isMobileUpsellTarget: false },
  { currentPath: 'channel.index', isMobile: true, isMobileUpsellTarget: false },
  { currentPath: 'directory.channels.all', isMobile: true, isMobileUpsellTarget: false },
  { currentPath: 'directory.games', isMobile: true, isMobileUpsellTarget: false },
  { currentPath: 'directory.game.index', isMobile: true, isMobileUpsellTarget: false },
  { currentPath: 'channel.post', isMobile: false, isMobileUpsellTarget: true }
].forEach(function ({currentPath, isMobile, isMobileUpsellTarget}) {
  let testName = `it triggers mobile transition on the ${currentPath} page when isMobile is ${isMobile} upsell is` +
  ` ${isMobileUpsellTarget}`;
  test(testName, function (assert) {
    let redirectSpy = sinon.spy();
    let runTaskSpy = sinon.spy();
    let controller = this.subject({
      redirectToMobileWeb: redirectSpy,
      runTask: runTaskSpy,
      currentPath,
      isMobileExperienceTarget: function () { return isMobile; },
      isMobileUpsellTarget: function () { return isMobileUpsellTarget; }
    });
    controller.checkForMobileRoute();
    assert.ok(runTaskSpy.calledOnce, `${currentPath} should trigger runTask`);
    runTaskSpy.getCall(0).args[0]();
    assert.ok(redirectSpy.calledOnce, `${currentPath} should trigger redirect`);
  });
});

[
  { currentPath: 'index', isMobile: false, isMobileUpsellTarget: true },
  { currentPath: 'channel.index', isMobile: false, isMobileUpsellTarget: true },
  { currentPath: 'directory.channels.all', isMobile: false, isMobileUpsellTarget: true },
  { currentPath: 'directory.games', isMobile: false, isMobileUpsellTarget: true },
  { currentPath: 'directory.game.index', isMobile: false, isMobileUpsellTarget: true },
  { currentPath: 'channel.post', isMobile: true, isMobileUpsellTarget: false }
].forEach(function ({currentPath, isMobile, isMobileUpsellTarget}) {
  let testName = `it does not trigger mobile transition on the ${currentPath} page when isMobile is ${isMobile} upsell` +
  ` is ${isMobileUpsellTarget}`;
  test(testName, function (assert) {
    let redirectSpy = sinon.spy();
    let runTaskSpy = sinon.spy();
    let controller = this.subject({
      redirectToMobileWeb: redirectSpy,
      runTask: runTaskSpy,
      currentPath,
      isMobileExperienceTarget: function () { return isMobile; },
      isMobileUpsellTarget: function () { return isMobileUpsellTarget; }
    });
    controller.checkForMobileRoute();
    assert.notOk(runTaskSpy.calledOnce, `${currentPath} should not trigger runTask`);
  });
});
