import { test } from 'ember-qunit';
import moduleFor from 'web-client/tests/helpers/module-for';

let controller;
let model = [
  {
    id: 13050606,
    access_start: null,
    access_end: '2016-12-31T21:48:09Z',
    expired: false,
    purchase_profile: {
      refundable: false,
      will_renew: false,
      paid_on: '2016-11-28T21:48:09Z',
      expired: false,
      payment_provider: 'samus',
      consecutive_months: 1
    },
    product: {
      name: 'Channel Subscription (qa_bits_partner)',
      short_name: 'qa_bits_partner',
      ticket_type: 'chansub',
      owner_name: 'qa_bits_partner',
      features: {
        bitrate_access: []
      },
      interval_number: 1,
      recurring: true,
      partner_login: 'qa_bits_partner',
      price: '$4.99',
      period: 'Month',
      emoticons: []
    }
  },
  {
    id: 13050604,
    access_start: null,
    access_end: '2016-12-31T21:48:01Z',
    expired: false,
    purchase_profile: {
      refundable: false,
      will_renew: false,
      paid_on: '2016-11-28T21:48:01Z',
      expired: false,
      payment_provider: 'samus',
      consecutive_months: 1
    },
    product: {
      name: 'Channel Subscription (qa_bits_partner)',
      short_name: 'qa_bits_partner',
      ticket_type: 'chansub',
      owner_name: 'qa_bits_partner',
      features: {
        bitrate_access: []
      },
      interval_number: 1,
      recurring: true,
      partner_login: 'qa_bits_partner',
      price: '$4.99',
      period: 'Month',
      emoticons: []
    }
  },
  {
    id: 9965565,
    access_start: null,
    access_end: '2017-11-01T00:00:00Z',
    expired: false,
    purchase_profile: {
      refundable: false,
      will_renew: false,
      paid_on: '2016-09-30T03:00:31Z',
      expired: false,
      payment_provider: 'samus',
      consecutive_months: 14
    },
    product: {
      name: 'Twitch Prime',
      short_name: 'twitch_prime',
      ticket_type: 'turbo',
      owner_name: null,
      features: {
        bitrate_access: []
      },
      interval_number: 1,
      recurring: false,
      partner_login: null,
      price: '$8.99',
      period: 'Year',
      emoticons: []
    }
  }
];
moduleFor('controller:backpack', 'Unit | Controller | backpack', {
  unit: true
});

test('duplicate tickets are deduped', function(assert) {
  assert.expect(1);

  controller = this.subject({ model: model });
  let filteredTickets = controller.get('filteredTickets');
  assert.equal(filteredTickets.length, 2);
});
