import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import RSVP from 'rsvp';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';

const adsEligibleCountry = Service.extend({
  getGeo() {
    return RSVP.resolve({
      geo: 'US'
    });
  }
});
const adsIneligibleCountry = Service.extend({
  getGeo() {
    return RSVP.resolve({
      geo: 'CN'
    });
  }
});
const inExperiment = Service.extend({
  getExperimentValue() {
    return RSVP.resolve('on');
  }
});

moduleForComponent('ads-for-bits-enabled');

test('site option disabled', function (assert) {
  this.inject.service('globals');

  this.globals.set('AdsForBits', false);
  this.owner.register('service:experiments', inExperiment);

  this.render(hbs`{{if (ads-for-bits-enabled) 'enabled' 'disabled'}}`);

  assert.equal(this.$().text(), 'disabled');
});

test('site option enabled but not in eligible country', function (assert) {
  this.inject.service('globals');

  this.globals.set('AdsForBits', true);
  this.owner.register('service:geo', adsIneligibleCountry);
  this.owner.register('service:experiments', inExperiment);

  this.render(hbs`{{if (ads-for-bits-enabled) 'enabled' 'disabled'}}`);

  assert.equal(this.$().text(), 'disabled');
});

test('site option enabled and in eligible country', function (assert) {
  this.inject.service('globals');

  this.globals.set('AdsForBits', true);
  this.owner.register('service:geo', adsEligibleCountry);
  this.owner.register('service:experiments', inExperiment);

  this.render(hbs`{{if (ads-for-bits-enabled) 'enabled' 'disabled'}}`);

  assert.equal(this.$().text(), 'enabled');
});
